% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

% Create Figure 6

%% Load results 
A_data          = readmatrix(sprintf('%s/Figure6_A_data.csv',PARMS.figfolder));
F_data          = readmatrix(sprintf('%s/Figure6_F_data.csv',PARMS.figfolder));
data            = readmatrix(sprintf('%s/Figure6_data.csv',PARMS.figfolder));


%%

datapart        = 100*[[data ; 0], zeros(2,5)];
Apart           = 100*[zeros(2,3), [A_data(2); A_data(1)-A_data(2)], zeros(2,2)];
Fpart           = 100*[zeros(2,5), [0; F_data]];

H3              = bar(1:6,datapart,'stacked','FaceColor',rgb('dark sky blue'));
hold on
H               = bar(1:6,Apart,'stacked');
H(1).FaceColor  = 'flat';
H(1).CData      = rgb('azure');
H(2).FaceColor  = 'flat';
H(2).CData      = rgb('red orange');
H2              = bar(1:6,Fpart,'stacked','FaceColor',rgb('red orange'));
set(gca,'FontSize',15,'TickLabelInterpreter', 'latex')
set(gca,'XTick',[1  4 6 ])
xticklabels({'Data' ,'A model','$\bar F$ model'})
AX              = legend(H,{'Direct','Indirect'},'interpreter','latex','Location','Northeast');
AX.FontSize     = 14;
ylabel('Cyclicality of aggregate producitivity (in \%)','Interpreter','latex');
ylim([0 2])

%% Clean up

clear A* data* F* H* 

